/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.parser.internal;

import icyllis.flexmark.util.sequence.BasedSequence;
import java.util.BitSet;

public class LinkDestinationParser {
    public final BitSet EXCLUDED_0_TO_SPACE_CHARS;
    public final BitSet JEKYLL_EXCLUDED_CHARS;
    public final BitSet PAREN_EXCLUDED_CHARS;
    public final BitSet PAREN_ESCAPABLE_CHARS;
    public final BitSet PAREN_QUOTE_CHARS;
    public final boolean allowMatchedParentheses;
    public final boolean spaceInUrls;
    public final boolean parseJekyllMacrosInUrls;
    public final boolean intellijDummyIdentifier;

    public LinkDestinationParser(boolean allowMatchedParentheses, boolean spaceInUrls, boolean parseJekyllMacrosInUrls, boolean intellijDummyIdentifier) {
        this.allowMatchedParentheses = allowMatchedParentheses || parseJekyllMacrosInUrls;
        this.spaceInUrls = spaceInUrls;
        this.parseJekyllMacrosInUrls = parseJekyllMacrosInUrls;
        this.intellijDummyIdentifier = intellijDummyIdentifier;
        this.EXCLUDED_0_TO_SPACE_CHARS = LinkDestinationParser.getCharSet('\u0000', ' ');
        if (intellijDummyIdentifier) {
            this.EXCLUDED_0_TO_SPACE_CHARS.clear(31);
        }
        this.JEKYLL_EXCLUDED_CHARS = LinkDestinationParser.getCharSet("{}\\");
        this.JEKYLL_EXCLUDED_CHARS.or(this.EXCLUDED_0_TO_SPACE_CHARS);
        this.JEKYLL_EXCLUDED_CHARS.clear(32);
        this.JEKYLL_EXCLUDED_CHARS.clear(9);
        this.PAREN_EXCLUDED_CHARS = LinkDestinationParser.getCharSet("()\\");
        this.PAREN_EXCLUDED_CHARS.or(this.EXCLUDED_0_TO_SPACE_CHARS);
        this.PAREN_ESCAPABLE_CHARS = LinkDestinationParser.getCharSet("\"#$%&'()*+,./:;<=>?@[]\\^_`{|}~-");
        this.PAREN_QUOTE_CHARS = LinkDestinationParser.getCharSet("\"'");
    }

    public BasedSequence parseLinkDestination(BasedSequence input, int startIndex) {
        int iMax = input.length();
        int lastMatch = startIndex;
        int openParenCount = 0;
        int openParenState = 0;
        int jekyllOpenParens = 0;
        int openJekyllState = this.parseJekyllMacrosInUrls ? 0 : -1;
        for (int i = startIndex; i < iMax; ++i) {
            char c = input.charAt(i);
            int nextIndex = i + 1;
            if (openJekyllState >= 0) {
                switch (openJekyllState) {
                    case 0: {
                        if (openParenState == 1 || c != '{' || input.safeCharAt(nextIndex) != '{') break;
                        openJekyllState = 1;
                        break;
                    }
                    case 1: {
                        if (openParenState != 1 && c == '{') {
                            jekyllOpenParens = 0;
                            openJekyllState = 2;
                            break;
                        }
                        openJekyllState = 0;
                        break;
                    }
                    case 2: {
                        if (openParenState == 1) break;
                        if (c == '}') {
                            openJekyllState = 3;
                            break;
                        }
                        if (c == '(') {
                            ++jekyllOpenParens;
                            break;
                        }
                        if (c == ')') {
                            if (jekyllOpenParens > 0) {
                                if (openParenState != -1) {
                                    lastMatch = nextIndex;
                                }
                                --jekyllOpenParens;
                                break;
                            }
                            openJekyllState = 0;
                            break;
                        }
                        if (!this.JEKYLL_EXCLUDED_CHARS.get(c)) break;
                        openParenCount += jekyllOpenParens;
                        openJekyllState = 0;
                        break;
                    }
                    case 3: {
                        if (openParenState != 1) {
                            if (c == '}') {
                                lastMatch = nextIndex;
                                openParenState = 0;
                                openJekyllState = 0;
                                break;
                            }
                            if (this.JEKYLL_EXCLUDED_CHARS.get(c)) {
                                openParenCount += jekyllOpenParens;
                                openJekyllState = 0;
                                break;
                            }
                        }
                        openJekyllState = 2;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal Jekyll Macro Parsing State");
                    }
                }
            }
            if (openParenState >= 0) {
                switch (openParenState) {
                    case 0: {
                        if (c == '\\') {
                            if (this.PAREN_ESCAPABLE_CHARS.get(input.safeCharAt(nextIndex))) {
                                openParenState = 1;
                            }
                            lastMatch = nextIndex;
                            break;
                        }
                        if (c == '(') {
                            if (openJekyllState != 2) {
                                if (this.allowMatchedParentheses) {
                                    ++openParenCount;
                                } else if (openParenCount == 0) {
                                    ++openParenCount;
                                } else {
                                    lastMatch = startIndex;
                                    openParenState = -1;
                                    break;
                                }
                            }
                            lastMatch = nextIndex;
                            break;
                        }
                        if (c == ')') {
                            if (openJekyllState == 2) break;
                            if (openParenCount > 0) {
                                --openParenCount;
                                lastMatch = nextIndex;
                                break;
                            }
                            if (!this.allowMatchedParentheses) {
                                openParenState = -1;
                                break;
                            }
                        } else if (c == ' ') {
                            if (this.spaceInUrls && !this.PAREN_QUOTE_CHARS.get(input.safeCharAt(nextIndex))) {
                                break;
                            }
                        } else if (!this.PAREN_EXCLUDED_CHARS.get(c)) {
                            lastMatch = nextIndex;
                            break;
                        }
                        openParenState = -1;
                        break;
                    }
                    case 1: {
                        lastMatch = nextIndex;
                        openParenState = 0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Illegal Jekyll Macro Parsing State");
                    }
                }
            }
            if (openJekyllState <= 0 && openParenState == -1) break;
        }
        return input.subSequence(startIndex, lastMatch);
    }

    public static BitSet getCharSet(CharSequence chars) {
        BitSet charSet = new BitSet(chars.length());
        int iMax = chars.length();
        for (int i = 0; i < iMax; ++i) {
            charSet.set(chars.charAt(i));
        }
        return charSet;
    }

    public static BitSet getCharSet(char charFrom, char charTo) {
        BitSet charSet = new BitSet();
        for (int i = charFrom; i <= charTo; ++i) {
            charSet.set(i);
        }
        return charSet;
    }
}

